% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{is_continuous}
\alias{is_continuous}
\title{Check if distribution in \verb{<epiparameter>} is continuous}
\usage{
is_continuous(x)
}
\arguments{
\item{x}{An \verb{<epiparameter>} object.}
}
\value{
A boolean \code{logical}.
}
\description{
Check if distribution in \verb{<epiparameter>} is continuous
}
\details{
The \verb{<epiparameter>} class can hold \verb{<distribution>} and
\verb{<distcrete>} probability distribution objects from the \pkg{distributional}
package and the \pkg{distcrete} package, respectively. \verb{<distribution>}
objects can be continuous or discrete distributions (e.g. gamma or negative
binomial), and all \verb{<distcrete>} objects are discrete.
}
\examples{
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "lnorm",
    prob_distribution_params = c(meanlog = 1, sdlog = 1)
  )
)
is_continuous(ep)
is_continuous(discretise(ep))

ep <- epiparameter(
  disease = "ebola",
  epi_name = "offspring distribution",
  prob_distribution = create_prob_distribution(
    prob_distribution = "nbinom",
    prob_distribution_params = c(mean = 2, dispersion = 0.5)
  )
)
is_continuous(ep)
}
