% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_surv_data.R
\name{inspect_surv_data}
\alias{inspect_surv_data}
\title{Inspect Survival Data}
\usage{
inspect_surv_data(data, time, event, group = NULL)
}
\arguments{
\item{data}{A data frame containing the survival data.}

\item{time}{The column name in \code{data} containing the time-to-event data.}

\item{event}{The column name in \code{data} containing the event indicator data.}

\item{group}{Optional. The column name in \code{data} containing the group
indicator data.}
}
\value{
A list containing tibbles that summarise the first few rows of the
survival data, the sample sizes, the events, and median survival.
}
\description{
Quickly inspect the survival data to ensure it is in the correct format.
}
\examples{
inspect_surv_data(
  data = easysurv::easy_bc,
  time = "recyrs",
  event = "censrec",
  group = "group"
)
}
