% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_encode_meta_to_xml}
\alias{EPM_encode_meta_to_xml}
\title{Encode Metadata to an XML String.}
\usage{
EPM_encode_meta_to_xml(meta, job_list, i, encoding)
}
\arguments{
\item{meta}{List including metadata associated with an easyPubMed query job. 
It corresponds to the contents of the `meta` slot of an
easyPubMed object.}

\item{job_list}{Data.frame that defines the list of sub-queries of an 
easyPubMed query job. It corresponds to the
'job_list' data.frame included in the `misc` slot of an
easyPubMed object.}

\item{i}{Integer, index of the batch (query sub-job) being written to file.}

\item{encoding}{String, this is the Encoding of the contents/text being 
retrieved from the Entrez server (typically, 'UTF-8').}
}
\value{
String, chunck of XML-decorated text including meta information.
}
\description{
Encode a list of meta information from an easyPubMed object 
into an XML string. These meta-information are used to keep track 
of easyPubMed query jobs and/or to re-build objects
starting from XML files saved on a local disk.
}
\examples{
tmp_meta <- list(max_records_per_batch = 1000, 
                 exp_count = 10, 
                 exp_num_of_batches = 1, 
                 all_records_covered = TRUE, 
                 exp_missed_records = 0, 
                 query_date = "2023-10-16 23:13:29", 
                 UID = 'EPMJ_20231017141741_c4das',
                 EPM_version = "3.01")
tmp_jobs <- data.frame(query_string = 'my test query', 
                       init_date = '1990/01/01', 
                       end_date = '2023/01/01', 
                       diff_days = 12053,
                       exp_count = 10, 
                       stringsAsFactors = FALSE)
easyPubMed:::EPM_encode_meta_to_xml(meta = tmp_meta, job_list = tmp_jobs, 
                                    i = 1, encoding = 'UTF-8' )



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
