% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{zodiac}
\alias{zodiac}
\title{Get zodiac corresponding to date(s)}
\source{
See 
\url{https://en.wikipedia.org/wiki/Zodiac} or 
\url{https://de.wikipedia.org/wiki/Tierkreiszeichen} 
for alternative date ranges.
}
\usage{
zodiac(
  x,
  out = "en",
  zodiac_swap_mmdd = c(120, 219, 321, 421, 521, 621, 723, 823, 923, 1023, 1123, 1222)
)
}
\arguments{
\item{x}{Date (as a scalar or vector, required).
If \code{x} is not a date (of class "Date"), 
the function tries to coerce \code{x} into a "Date".}

\item{out}{Output format (as character). 
Available output formats are: 
English/Latin (\code{out = "en"}, by default),   
German/Deutsch (\code{out = "de"}), 
HTML (\code{out = "html"}), or  
Unicode (\code{out = "Unicode"}) symbols.}

\item{zodiac_swap_mmdd}{Monthly dates on which 
the 12 zodiac signs switch (in \code{mmdd} format, 
ordered chronologically within a calendar year). 
Default: \code{zodiac_swap_mmdd = c(0120, 0219, 0321, 0421, 0521, 0621, 
0723, 0823, 0923, 1023, 1123, 1222)}.}
}
\value{
Zodiac label or symbol (as a factor).
}
\description{
\code{zodiac} provides the tropical zodiac sign or symbol 
(aka. astrological sign) for given date(s) \code{x}.
}
\details{
\code{zodiac} is flexible by providing different 
output formats (in Latin/English, German, or Unicode/HTML, 
see \code{out}) and allowing to adjust the calendar dates 
on which a new zodiac is assigned (via \code{zodiac_swap_mmdd}).
}
\examples{
zodiac(Sys.Date())

# Works with vectors:
dt <- sample_date(size = 10)
zodiac(dt)
levels(zodiac(dt))

# Alternative outputs:
zodiac(dt, out = "de")  # German/deutsch
zodiac(dt, out = "Unicode")  # Unicode
zodiac(dt, out = "HTML")     # HTML

# Alternative date breaks:
zodiac("2000-08-23")  # 0823 is "Virgo" by default
zodiac("2000-08-23",  # change to 0824 (i.e., August 24): 
       zodiac_swap_mmdd = c(0120, 0219, 0321, 0421, 0521, 0621, 
                            0723, 0824, 0923, 1023, 1123, 1222))

}
\seealso{
\code{Zodiac()} function of the \strong{DescTools} package.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
