% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/door_barplot.R
\name{door_component_barplot}
\alias{door_component_barplot}
\title{Create DOOR component barplot}
\usage{
door_component_barplot(
  comp_table = NULL,
  n1 = NULL,
  n2 = NULL,
  summary_obj = NULL,
  data_type = c("freq", "prop")
)
}
\arguments{
\item{comp_table}{A DOOR component table}

\item{n1, n2}{Sample sizes of group 1, group 2}

\item{summary_obj}{An object returned by \code{individual_to_summary()}; Alternative
input for comp_table.}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
if "comp_table" is used}
}
\value{
A ggplot object
}
\description{
Create DOOR component barplot
}
\examples{
comp_table = data.frame(compname = c("A", "B"), trt = c(30, 20), ctr = c(40, 25))
door_component_barplot(comp_table = comp_table, n1 = 100, n2 = 100)
}
