% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_binary.R
\name{dist_binary}
\alias{dist_binary}
\title{Compute pairwise binary distances}
\usage{
dist_binary(x, method)
}
\arguments{
\item{x}{A numeric matrix or data frame of binary values (0/1, TRUE/FALSE, or NA)}

\item{method}{A character string specifying the binary distance measure to use.}
}
\value{
A symmetric numeric matrix of pairwise distances. NA is returned for pairs
  with no valid comparisons (all NA entries).
}
\description{
Internal helper function to compute pairwise distances between binary vectors
using standard binary distance/similarity measures. Delegates to
\code{ade4::dist.binary} when available for performance.
}
\details{
Supported methods (for two binary vectors \eqn{x_i} and \eqn{x_j}):
\itemize{
  \item \code{"jaccard"}: \deqn{d = 1 - \frac{a}{a + b + c}}
  \item \code{"dice"}: \deqn{d = 1 - \frac{2a}{2a + b + c}}
  \item \code{"sokal_michener"}: \deqn{d = 1 - \frac{a + d}{a + b + c + d}}
  \item \code{"russell_rao"}: \deqn{d = 1 - \frac{a}{a + b + c + d}}
  \item \code{"sokal_sneath"}: \deqn{d = 1 - \frac{a}{a + 1/2(b + c)}}
  \item \code{"kulczynski"}: \deqn{d = 1 - \frac{1}{2}\left(\frac{a}{a+b} + \frac{a}{a+c}\right)}
  \item \code{"hamming"}: \deqn{d = 1 - \frac{a + d}{a + b + c + d}}
}

Where:
\itemize{
  \item \eqn{a} = number of positions where both vectors are 1
  \item \eqn{b} = number of positions where x_i = 1 and x_j = 0
  \item \eqn{c} = number of positions where x_i = 0 and x_j = 1
  \item \eqn{d} = number of positions where both vectors are 0
}

The Sokal-Michener coefficient is equivalent to the normalized Hamming distance.


\itemize{
 \item Factors or character columns are converted to numeric 0/1.
 \item Missing values (NA) are ignored pairwise; if all entries are missing, distance is NA.
 \item Methods supported by \code{ade4} (e.g., Jaccard, Dice, Sokal-Michener, etc.) are
  computed via \code{ade4::dist.binary} for efficiency.
 \item Manual computations are implemented for Hamming and Kulczynski if \code{ade4} is unavailable.
}
}
\examples{
# Small example with binary matrix
mat <- matrix(c(
  1, 0, 1,
  1, 1, 0,
  0, 1, 1
), nrow = 3, byrow = TRUE)

# Example with Jaccard
dbrobust::dist_binary(mat, method = "jaccard")

# Example with Hamming
dbrobust::dist_binary(mat, method = "hamming")

}
\keyword{internal}
