% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histbxp.r
\name{histbxp}
\alias{histbxp}
\title{Function for building a figure having both an histogram
and a boxplot for a single random variable}
\usage{
histbxp(
  y = y,
  freq = NULL,
  freqlab = "Frequency",
  varlab = "Variable",
  eng = TRUE,
  refval = NA,
  print.refval = FALSE,
  col.hist = "gray",
  col.bxp = "gray",
  portrait = TRUE,
  oma = c(3, 0.5, 2, 0),
  mar = c(1, 4, 0.2, 1),
  cex.varlab = 1.2,
  refval.symbol = expression(bar(y)),
  col.refval = "blue",
  varlim = NA,
  freqlim = NA
)
}
\arguments{
\item{y}{A numeric vector representing the random variable.}

\item{freq}{A logical option for plotting the histograma. By
default it is set to \code{NULL}, thus uses the actual
frequencies. Meanwhile, when is \code{TRUE} the percentual
frequencies are plot, and if \code{FALSE} a density is
is used. Further details can be found in the function \code{hist()}.}

\item{freqlab}{(optional) A string specifying the frequency label.
The default is set to "Frequency".}

\item{varlab}{(optional) A string specifying the random variable
label. The default is set to "Variable".}

\item{eng}{logical; if "TRUE" (by default), the language of some
default text will be in English; if "FALSE" will be in Spanish.
The default is to "TRUE".}

\item{refval}{A numeric value to be used for printing as reference
for the random variable. By default is set to the mean of the
variable \code{y}.}

\item{print.refval}{A logical statement to define whether a
reference value should be printed, if set to TRUE, the
mean of the \code{y} vector will be plotted. The default is FALSE.}

\item{col.hist}{A string specifying the histogram color. The
default is "gray".}

\item{col.bxp}{A string specifying the boxplot color. The
default is "gray".}

\item{portrait}{A logical statement, if set to TRUE, the boxplot
will be located under the histogram (2 rows, 1 column). If is set
to FALSE, the boxplot will be located next to the
histogram (1 row, 2 columns). The default is TRUE.}

\item{oma}{As in the plot environment. The default
is  \code{c(3, .5, 2, 0)}.}

\item{mar}{As in the plot environment. The default
is \code{ c(1, 4.0, 0.2, 1)}.}

\item{cex.varlab}{A numeric value for the \code{cex} option of plotting
to the assigned \code{varlab} element. The default value is set
to \code{1.2} .}

\item{refval.symbol}{A string of type \code{expression} with name of the
\code{refval} being printed, if \code{print.refval} is set to TRUE. The default
is \code{expression(bar(y))}.}

\item{col.refval}{A string specifying the \code{refval.symbol} color,
if \code{print.refval} is set to TRUE. The default  is "blue"}

\item{varlim}{(optional) A numeric vector having the minimum and
maximum, respectively for the random variable.}

\item{freqlim}{(optional) A numeric vector having the minimum and
maximum, respectively for the frequency axis.}
}
\value{
The function returns the above described graph.
}
\description{
The function creates a figure having both an histogram and a
boxplot for a random variable, as a way to help understanding
its distribution.
}
\details{
The variable must be numeric.
}
\examples{
df <- datana::fishgrowth
histbxp(y=df$length)
histbxp(y=df$length,freq = TRUE)
histbxp(y=df$length,freq = FALSE)

## Now in Spanish
histbxp(y=df$length,eng=FALSE)
histbxp(y=df$length,freq = TRUE,eng=FALSE)
histbxp(y=df$length,freq = FALSE,eng=FALSE)

### distribution of 'length'
## with mean refval
histbxp(y=df$length, print.refval = TRUE)

## with given refval
histbxp(y=df$length, print.refval = TRUE, refval = 250)

## changing labels
histbxp(y=df$length, print.refval = TRUE, refval = 250,
        freqlab = "Freq", varlab = "Length")

## changing colors
histbxp(y=df$length, print.refval = TRUE, refval = 250,
        freqlab = "Freq", varlab = "Length",
        col.hist = "blue",
        col.bxp = "green",
        col.refval = "red")


### distribution of 'scale'
## with mean refval
histbxp(y=df$scale, print.refval = TRUE)

## landscape mode
histbxp(y=df$scale, print.refval = TRUE, portrait = FALSE)

## with limits
histbxp(y=df$scale, print.refval = TRUE, portrait = FALSE,
        freqlim = c(0,100),
        varlim = c(0, max(df$scale)))

}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa
estadístico R:
una introducción aplicada.
Ediciones Universidad Mayor. Santiago, Chile. 170 p.
\url{https://eljatib.com}
}

\itemize{
\item Salas C, Stage AR, and Robinson AP. 2008. Modeling effects of
overstory density and competing
vegetation on tree height growth. Forest Science 54(1):107-122.
\doi{10.1093/forestscience/54.1.107}
}
}
\author{
Christian Salas-Eljatib
}
