% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.bases.r
\name{gl.report.bases}
\alias{gl.report.bases}
\title{Reports summary of base pair frequencies}
\usage{
gl.report.bases(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity].}

\item{...}{Parameters passed to function \link[ggplot2]{ggsave}, 
such as width and height, when the ggplot is to be saved.}
}
\value{
The unchanged genlight object
}
\description{
Calculates the frequencies of the four DNA nucleotide bases:
adenine (A), cytosine (C), 'guanine (G) and thymine (T), and the frequency of
transitions (Ts) and transversions (Tv) in a DArT genlight object.
}
\details{
The function checks first if trimmed sequences are included in the
locus metadata (@other$loc.metrics$TrimmedSequence), and if so, tallies up
the numbers of A, T, G and C bases. Only the reference state at the SNP locus
is counted. Counts of transitions (Ts) and transversions (Tv) assume that
there is no directionality, that is C->T is the same as T->C, because the
reference state is arbitrary.
For presence/absence data (SilicoDArT), it is not possible to count
transversions or transitions or transversions/transitions ratio because the
SNP data are not available, only a single sequence tag per locus. Only base frequencies
are provided.
 A color vector can be obtained with gl.select.colors() and then passed to the function
 with the plot.colors parameter.
If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.
 If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir(). 
To avoid issues from inadvertent use of this function in an assignment statement,
the function returns the genlight object unaltered.
}
\examples{
# SNP data
  out <- gl.report.bases(testset.gl)
  col <- gl.select.colors(select=c(6,1),palette=rainbow, verbose=0)
  out <- gl.report.bases(testset.gl,plot.colors=col)
# Tag P/A data
  out <- gl.report.bases(testset.gs)
}
\seealso{
Other matched reports: 
\code{\link{gl.mahal.assign}()},
\code{\link{gl.report.factorloadings}()},
\code{\link{gl.report.fstat}()},
\code{\link{gl.report.monomorphs}()}
}
\author{
Author(s); Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched reports}
