% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{splice}
\alias{splice}
\alias{splice,CppList-method}
\title{Move elements}
\usage{
splice(x, y, x_position, y_from, y_to)
}
\arguments{
\item{x}{A CppList object to which to add elements.}

\item{y}{A CppList object, of the same data type as \code{x}, from which to extract elements.}

\item{x_position}{Index at which to insert elements in \code{x}.}

\item{y_from}{Index of the first element to extract from \code{y}.}

\item{y_to}{Index of the last element to extract from \code{y}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Move elements from one list to another list by reference.
}
\examples{
x <- cpp_list(4:9)
x
# 4 5 6 7 8 9

y <- cpp_list(10:12)
y
# 10 11 12

splice(x, y, 3, 2, 3)
x
# 4 5 11 12 6 7 8 9
y
# 10

}
\seealso{
\link{merge}, \link{splice_after}.
}
