% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emplace_after.R
\name{emplace_after}
\alias{emplace_after}
\alias{emplace_after,CppForwardList-method}
\title{Add an element}
\usage{
emplace_after(x, value, position)
}
\arguments{
\item{x}{A CppForwardList object.}

\item{value}{Value to add to \code{x}.}

\item{position}{Index after which to insert the element. Indices start at 1. The function does not perform bounds checks. Indices outside \code{x} crash 
the program.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add an element to a forward list by reference in place.
}
\details{
The emplace methods only add single elements. Use \link{insert} to add multiple elements in one call.
}
\examples{
l <- cpp_forward_list(4:6)
l
# 4 5 6

emplace_after(l, 10L, 2)
l
# 4 5 10 6

}
\seealso{
\link{emplace}, \link{emplace_back}, \link{emplace_front}, \link{insert}.
}
