% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-atomic.R
\name{opts_atomic}
\alias{opts_atomic}
\title{Constructive options for atomic types}
\usage{
opts_atomic(
  ...,
  trim = NULL,
  fill = c("default", "rlang", "+", "...", "none"),
  compress = TRUE
)
}
\arguments{
\item{...}{Additional options used by user defined constructors through the \code{opts} object}

\item{trim}{\code{NULL} or integerish. Maximum of elements showed before it's trimmed.
Note that it will necessarily produce code that doesn't reproduce the input.
This code will parse without failure but its evaluation might fail.}

\item{fill}{String. Method to use to represent the trimmed elements.}

\item{compress}{Boolean. If \code{TRUE} instead of \code{c()} Use \code{seq()}, \code{rep()}
when relevant to simplify the output.}
}
\value{
An object of class <constructive_options/constructive_options_atomic>
}
\description{
These options will be used on atomic types ("logical", "integer", "numeric", "complex", "character" and "raw").
They can also be directly provided to atomic types through their own \verb{opts_*()}
function, and in this case the latter will have precedence.
}
\details{
If \code{trim} is provided, depending on \code{fill} we will present trimmed elements as followed:
\itemize{
\item \code{"default"} : Use default atomic constructors, so for instance \code{c("a", "b", "c")} might become \code{c("a", character(2))}.
\item \code{"rlang"} : Use rlang atomic constructors, so for instance \code{c("a", "b", "c")} might become \code{c("a", rlang::new_character(2))},
these \code{rlang} constructors create vectors of \code{NAs}, so it's different from the default option.
\item \code{"+"}: Use unary \code{+}, so for instance \code{c("a", "b", "c")} might become \code{c("a", +2)}.
\item \code{"..."}: Use \code{...}, so for instance \code{c("a", "b", "c")} might become \code{c("a", ...)}
\item \code{"none"}: Don't represent trimmed elements.
}

Depending on the case some or all of the choices above might generate code that
cannot be executed. The 2 former options above are the most likely to succeed
and produce an output of the same type and dimensions recursively. This would
at least be the case for data frame.
}
\examples{
construct(iris, opts_atomic(trim = 2), check = FALSE) # fill = "default"
construct(iris, opts_atomic(trim = 2, fill = "rlang"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "+"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "..."), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "none"), check = FALSE)
construct(iris, opts_atomic(trim = 2, fill = "none"), check = FALSE)
x <- c("a a", "a\U000000A0a", "a\U00002002a", "\U430 \U430")
}
