% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagmatrix.R
\name{lagmatrix}
\alias{lagmatrix}
\title{Create lags or leads of a matrix}
\usage{
lagmatrix(x, lag)
}
\arguments{
\item{x}{A matrix or multivariate time series.}

\item{lag}{A vector of lags (positive values) or leads (negative values) with
a length equal to the number of columns of \code{x}.}
}
\value{
A matrix with the same class and size as \code{x}.
}
\description{
Find a shifted version of a matrix, adjusting the time base backward (lagged)
or forward (leading) by a specified number of observations for each column.
}
\examples{
x <- matrix(rnorm(20), nrow = 5, ncol = 4)

# Create lags of a matrix
lagmatrix(x, c(0, 1, 2, 3))

# Create leads of a matrix
lagmatrix(x, c(0, -1, -2, -3))

}
