% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{unless_converged}
\alias{unless_converged}
\title{Conditional Refinement}
\usage{
unless_converged(solver, refinement)
}
\arguments{
\item{solver}{Primary solver function}

\item{refinement}{Solver to use if primary doesn't converge}
}
\value{
A new solver function with conditional refinement
}
\description{
Applies a refinement solver only if the first solver did not converge.
If refinement is applied, trace data from both solvers is merged.
}
\examples{
# Use Newton-Raphson to refine if gradient ascent doesn't converge
strategy <- unless_converged(gradient_ascent(max_iter = 50), newton_raphson())

}
