% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{createPatientProfileVar}
\alias{createPatientProfileVar}
\title{Create link to patient profile}
\usage{
createPatientProfileVar(
  data,
  patientProfilePath,
  subjectVar = "USUBJID",
  checkExist = TRUE
)
}
\arguments{
\item{data}{a data.frame}

\item{patientProfilePath}{string indicating the directory 
where the patient profiles are stored.}

\item{subjectVar}{string indicating which column in the data represents the
unique subject identifier, "USUBJID" by default.}

\item{checkExist}{Logical, if TRUE (by default)
the \code{patientProfilePath} is checked for existence,
and an error is returned if this directory doesn't exist.}
}
\value{
A data.frame with two extra columns:
\code{patientProfilePath} and \code{patientProfileLink} with
the path to the patient profile and an hyperlink to it, respectively.
}
\description{
Create a link to a patient profile directory
(where the patient profile files are saved) by adding an extra column with the link
in the data.
The path to the patient profile is built as:
[patientProfilePath]/subjectProfile-[subjectID].pdf,
where '/' are replaced with '-' in the subject 
identifier (\code{subjectVar}).
}
\examples{
# Typical CDISC dataset contains universal subject ID (USUBJID)
data <- data.frame(USUBJID = c("subj1", "subj2", "subj3"))
dataWithPatientProfileVar <- createPatientProfileVar(
  data = data, 
  patientProfilePath = "pathProfiles", 
  checkExist = FALSE
)
# path and HTML link are included in the output dataset
head(dataWithPatientProfileVar[, c("USUBJID", "patientProfilePath", "patientProfileLink")])
}
\author{
Michela Pasetto
}
