% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_warnings}
\alias{autobahn_warnings}
\title{List Autobahn warnings}
\usage{
autobahn_warnings(road_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{road_id}{Road identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with warnings.
}
\description{
List Autobahn warnings
}
\details{
Returns current warnings for a specific Autobahn road id.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
autobahn_warnings(roads$road_id[[1]], flatten = TRUE)
}
}
\seealso{
\code{\link[=autobahn_roads]{autobahn_roads()}} to list roads and \code{\link[=autobahn_warning_details]{autobahn_warning_details()}} for details.
}
