% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_roadworks}
\alias{autobahn_roadworks}
\title{List Autobahn roadworks}
\usage{
autobahn_roadworks(road_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{road_id}{Road identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with roadworks.
}
\description{
List Autobahn roadworks
}
\details{
Returns current roadworks for a specific Autobahn road id.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
autobahn_roadworks(roads$road_id[[1]], flatten = TRUE)
}
}
\seealso{
\code{\link[=autobahn_roads]{autobahn_roads()}} to list available roads, and \code{\link[=autobahn_roadwork_details]{autobahn_roadwork_details()}}
for detail records.
}
