% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/booami_predict.R
\name{booami_predict}
\alias{booami_predict}
\title{Predict with booami models}
\usage{
booami_predict(
  object,
  X_new,
  family = NULL,
  type = c("response", "link"),
  center_means = NULL
)
}
\arguments{
\item{object}{A fit returned by \code{cv_boost_raw()}, \code{cv_boost_imputed()},
or a \emph{pooled} \code{impu_boost()} (i.e., \code{pool = TRUE} so that
\code{$BETA} is a length-\eqn{p} vector and \code{$INT} is a scalar).}

\item{X_new}{New data (matrix or data.frame) with the same \eqn{p} predictors
the model was trained on. If column names are present in the model,
\code{X_new} will be aligned by name; otherwise it must be in the same order.}

\item{family}{Model family; one of \code{c("gaussian","logistic")}. If
\code{NULL}, the function tries to infer from \code{object$type} or
attributes; otherwise defaults to \code{"gaussian"}.}

\item{type}{Prediction type; one of \code{c("response","link")}. For
\code{"gaussian"}, both are identical. For \code{"logistic"},
\code{"response"} returns probabilities via the inverse-logit.}

\item{center_means}{Optional numeric vector of length \eqn{p} with training
means used to center predictors during fitting. If provided, \code{X_new}
is centered as \code{X_new - center_means} before prediction. If the model
stores means by name, pass a named vector whose names match predictor names.}
}
\value{
A numeric vector of predictions (length \code{nrow(X_new)}). If
\code{X_new} has row names, they are propagated to the returned vector.
}
\description{
Minimal, dependency-free predictor for models fitted by
\code{\link{cv_boost_raw}}, \code{\link{cv_boost_imputed}}, or a
\emph{pooled} \code{\link{impu_boost}} fit. Supports Gaussian (identity)
and logistic (logit) models, returning either the linear predictor
or, for logistic, predicted probabilities.
}
\details{
This function is deterministic and involves no random number generation.
Coefficients are extracted from either \code{$final_model} (intercept first,
then coefficients) or from \code{$INT}+\code{$BETA} (pooled \code{impu_boost}).
If \code{X_new} has column names and the model has named coefficients, columns
are aligned by name; otherwise they are used in order.

If your training pipeline centered covariates (e.g., \code{center = "auto"}),
providing the same \code{center_means} here yields numerically consistent
predictions. If not supplied but \code{object$center_means} exists, it will
be used automatically. If both are supplied, the explicit \code{center_means}
argument takes precedence.
}
\examples{
\dontshow{if (requireNamespace("mice", quietly = TRUE) && requireNamespace("miceadds", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# 1) Fit on data WITH missing values
set.seed(123)
sim_tr <- simulate_booami_data(
  n = 120, p = 12, p_inf = 3,
  type = "gaussian",
  miss = "MAR", miss_prop = 0.20
)
X_tr <- sim_tr$data[, 1:12]
y_tr <- sim_tr$data$y

fit <- cv_boost_raw(
  X_tr, y_tr,
  k = 2, mstop = 50, seed = 123,
  impute_args    = list(m = 2, maxit = 1, printFlag = FALSE, seed = 1),
  quickpred_args = list(method = "spearman", mincor = 0.30, minpuc = 0.60),
  show_progress  = FALSE
)

# 2) Predict on a separate data set WITHOUT missing values (same p)
sim_new <- simulate_booami_data(
  n = 5, p = 12, p_inf = 3,
  type = "gaussian",
  miss = "MCAR", miss_prop = 0   # <- complete data with existing API
)
X_new <- sim_new$data[, 1:12, drop = FALSE]

preds <- booami_predict(fit, X_new = X_new, family = "gaussian", type = "response")
round(preds, 3)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{cv_boost_raw}}, \code{\link{cv_boost_imputed}}, \code{\link{impu_boost}}
}
