% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_models.R
\name{Metselaar_iso}
\alias{Metselaar_iso}
\title{Isothermal Metselaar model}
\usage{
Metselaar_iso(time, temp, D_R, z, p, Delta, temp_ref)
}
\arguments{
\item{time}{numeric indicating the time at which the prediction is taken.}

\item{temp}{numeric indicating the temperature of the treatment.}

\item{D_R}{numeric defining the delta-value at the reference temperature.}

\item{z}{numeric defining the z-value.}

\item{p}{numeric defining shape factor of the Weibull distribution.}

\item{Delta}{numeric reparametrization factor}

\item{temp_ref}{numeric indicating the reference temperature.}
}
\value{
A numeric with the predicted logarithmic reduction
(\eqn{log10(N/N0)}).
}
\description{
Returns the predicted logarithmic reduction in microbial count according
to Metselaars's model for the time, temperature and model parameters
given.
}
