% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{survivalists}
\alias{survivalists}
\title{Survivalists}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{version}}{Country code for the version of the show}
  \item{\code{season}}{The season number}
  \item{\code{id}}{Survivalist ID}
  \item{\code{name}}{Name of the survivalist}
  \item{\code{first_name}}{First name of the survivalist}
  \item{\code{last_name}}{Last name of the survivalist}
  \item{\code{age}}{Age of survivalist}
  \item{\code{gender}}{Gender}
  \item{\code{city}}{City}
  \item{\code{state}}{State}
  \item{\code{country}}{Country}
  \item{\code{result}}{Place the survivalist finished in the season}
  \item{\code{days_lasted}}{The number of days lasted in the game before tapping out or winning}
  \item{\code{medically_evacuated}}{Logical. If the survivalist was medically evacuated from the game}
  \item{\code{reason_tapped_out}}{The reason the survivalist tapped out of the game. \code{NA} means
  they were the winner}
  \item{\code{reason_category}}{A simplified category of the reason for tapping out}
  \item{\code{episode_tapped}}{Episode tapped out}
  \item{\code{team}}{The team they were associated with (only for season 4)}
  \item{\code{day_linked_up}}{Day the team members linked up}
  \item{\code{profession}}{Profession}
}
}
\source{
\url{https://en.wikipedia.org/wiki/List_of_Alone_episodes#Season_1_(2015)_-_Vancouver_Island}
}
\usage{
survivalists
}
\description{
Contains details of each survivalist including demographics and results.
}
\examples{
library(dplyr)
library(ggplot2)

survivalists |>
  count(reason_category, gender) |>
  filter(!is.na(reason_category)) |>
  ggplot(aes(reason_category, n, fill = gender)) +
  geom_col()
}
\keyword{datasets}
