% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_contrast.R
\name{point_contrast}
\alias{point_contrast}
\alias{summary.curve_est_contrast}
\title{Contrast point estimates along an effect curve}
\usage{
point_contrast(object)

\method{summary}{curve_est_contrast}(
  object,
  conf_level = 0.95,
  simultaneous = TRUE,
  null = 0,
  ci.type = "perc",
  df = NULL,
  ...
)
}
\arguments{
\item{object}{for \code{point_contrast()}, a \code{\link{curve_est}} object; the output of a an \code{effect_curve} object. For \code{summary()}, a \code{curve_est_contrast} object; the output of a call to \code{point_contrast()}.}

\item{conf_level}{the desired confidence level. Set to 0 to omit confidence intervals. Default is .95.}

\item{simultaneous}{\code{logical}; whether the computed p-values and confidence intervals should be simultaneous (\code{TRUE}) or pointwise (\code{FALSE}). Simultaneous (also known as uniform) intervals jointly cover all specified estimates at the desired confidence level, whereas pointwise confidence intervals only cover each estimate at the desired level. Simultaneous p-values are inversions of the simultaneous confidence intervals. Default is \code{TRUE}. See Details.}

\item{null}{the null value for hypothesis tests. Default is 0. Set to \code{NA} to omit tests.}

\item{ci.type}{string; when bootstrapping or Bayesian inference is used in the original effect curve, which type of confidence interval is to be computed. For bootstrapping, allowable options include \code{"perc"} for percentile intervals, \code{"wald"} for Wald intervals, and other options allowed by \pkgfun{fwb}{summary.fwb}. When \code{simultaneous = TRUE}, only \code{"perc"} and \code{"wald"} are allowed. For Bayesian models, allowable options include \code{"perc"} for equi-tailed intervals and \code{"wald"} for Wald intervals. Default is \code{"perc"}. Ignored when bootstrapping is not used and the model is not Bayesian.}

\item{df}{the "denominator" degrees of freedom to use for the tests and critical test statistics for confidence intervals. Default is to use the residual degrees of freedom from the original model if it is a linear model and \code{Inf} otherwise.}

\item{...}{ignored.}
}
\value{
\code{point_contrast()} returns an object of class \code{curve_est_contrast}, which is like a \code{curve_est} object but with its own \code{summary()} method.
}
\description{
\code{point_contrast()} computes pairwise contrasts of estimates from an effect curve.
}
\details{
\code{point_contrast()} computes all pairwise contrasts between effect curve estimates. Because pairwise contrasts are a linear operation over the original estimates, the delta method can be used to perform Wald inference for the contrasts. When \code{by} was specified in the original call to \code{\link[=adrf]{adrf()}} or the effect curve is a \code{contrast_curve} object resulting from \code{\link[=curve_contrast]{curve_contrast()}}, pairwise contrasts occur only within subgroups or within subgroup contrasts, respectively. To compare points on an effect curve to a single point, use \code{\link[=reference_curve]{reference_curve()}}.
}
\examples{
data("nhanes3lead")

fit <- lm(Math ~ poly(logBLL, 5) *
            (Male + Age + Race + PIR +
               Enough_Food),
          data = nhanes3lead)

# ADRF of logBLL on Math, unconditional
# inference
adrf1 <- adrf(fit, treat = "logBLL")

# Differences among ADRF estimates at given points
adrf1(logBLL = c(0, 1, 2)) |>
  point_contrast() |>
  summary()
}
\seealso{
\itemize{
\item \code{\link[=adrf]{adrf()}} for computing the ADRF
\item \code{\link[=reference_curve]{reference_curve()}} for comparing points on an effect curve to a single point
\item \code{\link[=summary.curve_est]{summary.curve_est()}} for inference on individual points on an effect curve
\item \code{\link[marginaleffects:hypotheses]{marginaleffects::hypotheses()}} for general hypotheses on \code{curve_est} (and other) objects
}
}
