% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_helpers.R
\name{df_is}
\alias{df_is}
\title{Test type of a data frame.}
\usage{
df_is(df, type)
}
\arguments{
\item{df}{The data frame.}

\item{type}{The type you expect the columns to have.
It must be one of the R base types:
- 'character' ;
- 'factor' ;
- 'integer' ;
- 'numeric' ;
- 'logical'.}
}
\value{
\code{TRUE} or \code{FALSE}.
}
\description{
df_is
This function tests if the columns of a data frame are all of the same type.
}
\examples{
# Test if a data frame contains only integers
df <- data.frame(a = c(1, 4), b = c(6, 5))
# should return FALSE since in R all integers are converted to
# numeric by default.
W4MRUtils::df_is(df, "integer")
# should return TRUE.
W4MRUtils::df_is(df, "numeric")

}
