% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calc_photo}
\alias{calc_photo}
\title{calc_photo}
\usage{
calc_photo(leaf_temp, photo_active_rad, atmospheric_co2, ppl, pht)
}
\arguments{
\item{leaf_temp}{matrix with ntimesteps rows, nsites columns, containing leaf temperature [°C]}

\item{photo_active_rad}{matrix with ntimesteps rows, nsites columns, containing photosynthetically active radiation [umol*m^(-2)*s^(-1)]}

\item{atmospheric_co2}{matrix with ntimesteps rows, nsites columns, containing atmospheric CO2 partial pressure [Pa]}

\item{ppl}{a list of photosynthetic parameters (see \code{p3} and \code{p4})}

\item{pht}{a string indicating "c3" or "c4" photosynthesis}
}
\value{
matrix with ntimesteps rows, nsites columns, containing the calculated photosynthetic rates [umol*m^(-2)*s^(-1)]
}
\description{
Generates estimates of photosynthetic rates using a Farquar type photosynthesis model.
}
\details{
This function is called internally by \code{get_input()}.
}
