% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_lookup.R
\name{save_lookup}
\alias{save_lookup}
\title{Save a lookup table to a CSV file}
\usage{
save_lookup(df, savedir, name)
}
\arguments{
\item{df}{A data frame containing the lookup table data.}

\item{savedir}{A string, the path to the save directory.}

\item{name}{A string, the file name (should end in \code{.csv}).}
}
\value{
Nothing
}
\description{
\code{save_lookup()} saves a data frame as a CSV file (without row names) in the
specified directory.
}
\examples{
# Create a temp save directory and load an example
save_dir <- file.path(tempdir(), "TCRconvertR_tmp")
dir.create(save_dir, showWarnings = FALSE, recursive = TRUE)
dat <- read.csv(get_example_path("fasta_dir/lookup.csv"))

save_lookup(dat, save_dir, "newlookup.csv")

# Clean up temporary folder
unlink(save_dir, recursive = TRUE)
}
\keyword{internal}
