% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingP.R
\name{samplingP}
\alias{samplingP}
\title{Extract samples from generated populations.}
\usage{
samplingP(
  population,
  seeds,
  coupon,
  waves = NULL,
  size = NULL,
  prob = NULL,
  character_sam = NULL,
  showids = TRUE,
  timeInterval = NULL
)
}
\arguments{
\item{population}{Population generated using the 'SimRDS::population' function.}

\item{seeds}{Number of seeds.}

\item{coupon}{Number of coupons.}

\item{waves}{Number of waves.}

\item{size}{Sample size.}

\item{prob}{Whether the seeds are selected probabilistically. If you want to
be selected randomly, leave it as 'NULL' If you want to relate it to a variable,
add the variable name. For example, if the seeds selected depend on the
network size, then 'network' should be used. It should enter as '1/network'
if it is inversely proportional.}

\item{character_sam}{If the individuals from the network of an individual
should be chosen randomly use "NULL". If the selection should be done
probabilistically, state the variable and how it should be related. Possible
inputs are NULL, netSize, character.}

\item{showids}{If TRUE, it displays the IDs being recruited.}

\item{timeInterval}{Days between recruitment waves. Zeroth wave is assumed
to recruit at the present day.}
}
\value{
RDS sample
}
\description{
Extract samples from the generated populations using the `SimRDS::population`
function. Can directly use this output to the RDS estimates in the RDS package.
}
\examples{
\donttest{
RDS.population <- population(N = 1000,p.ties = 0.6,minVal = 10,zeros = 0,
pr = .5,pa = .1, atype_char = "net",atype_res = "net*char")

RDS.samplingP <- samplingP(population=RDS.population, seeds = 40, coupon = 2,
waves = 8, prob = '1/network', character_sam = 'netSize')
}

# This function may take considerable time to produce output, depending on
# the computer's performance. For a quick reference to the expected result,
# a saved version of the output is available.
data(RDS.samplingP)

}
