% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataLoadingSaving.R
\name{getDbSccsData}
\alias{getDbSccsData}
\title{Load data for SCCS from the database}
\usage{
getDbSccsData(
  connectionDetails,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  outcomeDatabaseSchema = cdmDatabaseSchema,
  outcomeTable = "condition_era",
  outcomeIds,
  exposureDatabaseSchema = cdmDatabaseSchema,
  exposureTable = "drug_era",
  customCovariateDatabaseSchema = cdmDatabaseSchema,
  customCovariateTable = "cohort",
  nestingCohortDatabaseSchema = cdmDatabaseSchema,
  nestingCohortTable = "cohort",
  getDbSccsDataArgs
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{ConnectionDetails} created using
the function \code{\link[DatabaseConnector:createConnectionDetails]{DatabaseConnector::createConnectionDetails()}} function.}

\item{cdmDatabaseSchema}{The name of the database schema that contains the OMOP CDM
instance.  Requires read permissions to this database. On SQL
Server, this should specify both the database and the
schema, so for example 'cdm_instance.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{outcomeDatabaseSchema}{The name of the database schema that is the location where
the data used to define the outcome cohorts is available. If
\code{outcomeTable = "condition_era"}, \code{outcomeDatabaseSchema} is not
used.  Requires read permissions to this database.}

\item{outcomeTable}{The table name that contains the outcome cohorts.  If
\code{outcomeTable} is not \code{"condition_era"},
then expectation is \code{outcomeTable} has format of cohort table (see
details).}

\item{outcomeIds}{A list of IDs used to define outcomes.  If \code{outcomeTable} is not
\code{"condition_era"} the list contains records found in the
\code{cohort_definition_id} field.}

\item{exposureDatabaseSchema}{The name of the database schema that is the location where
the exposure data used to define the exposure eras is
available. If \code{exposureTable = "drug_era"},
\code{exposureDatabaseSchema} is not used but assumed to be equal to
\code{cdmDatabaseSchema}.  Requires read permissions to this database.}

\item{exposureTable}{The tablename that contains the exposure cohorts.  If
\code{exposureTable} is not "drug_era", then expectation is \code{exposureTable}
has format of a cohort table (see details).}

\item{customCovariateDatabaseSchema}{The name of the database schema that is the location where
the custom covariate data is available.}

\item{customCovariateTable}{Name of the table holding the custom covariates. This table
should have the same structure as the cohort table (see details).}

\item{nestingCohortDatabaseSchema}{The name of the database schema that is the location
where the nesting cohort is defined.}

\item{nestingCohortTable}{Name of the table holding the nesting cohort. This table
should have the same structure as the cohort table (see details).}

\item{getDbSccsDataArgs}{An object of type \code{GetDbSccsDataArgs} as created by the \code{createGetDbSccsDataArgs()}
function.}
}
\value{
An \link{SccsData} object.
}
\description{
Load all data needed to perform an SCCS analysis from the database.
}
\details{
This function downloads several types of information:
\itemize{
\item Information on the occurrences of the outcome(s) of interest. Note that information for
multiple outcomes can be fetched in one go, and later the specific outcome can be specified
for which we want to build a model.
\item Information on the observation time and age for the people with the outcomes.
\item Information on exposures of interest which we want to include in the model.
}

Five different database schemas can be specified, for five different types of information: The
\itemize{
\item \strong{cdmDatabaseSchema} is used to extract patient age and observation period. The
\item \strong{outcomeDatabaseSchema} is used to extract information about the outcomes, the
\item \strong{exposureDatabaseSchema} is used to retrieve information on exposures, and the
\item \strong{customCovariateDatabaseSchema} is optionally used to find additional, user-defined
covariates. All four locations could point to the same database schema.
\item \strong{nestingCohortDatabaseSchema} is optionally used to define a cohort in which the analysis is nested,
for example a cohort of diabetics patients.
}

All five locations could point to the same database schema.

Cohort tables are assumed to have the following fields: \code{cohort_definition_id}, \code{subject_id},
\code{cohort_start_date}, and \code{cohort_end_date.}
}
\section{Study period start and end dates}{

A study start and end date define a period when patient data will be included in the
analysis. Multiple non-overlapping periods can be defined, which for example will allow
for excluding the time of the COVID pandemic, when most outcome rates were unstable.
}

