% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matmult.syncsa.R
\encoding{UTF-8}
\name{matmult.syncsa}
\alias{matmult.syncsa}
\title{Matrix multiplication with missing data}
\usage{
matmult.syncsa(X, Y)
}
\arguments{
\item{X}{A matrix, typically the standardized community matrix (W).}

\item{Y}{A matrix.}
}
\value{
The matrix product.
}
\description{
Function to get the matrix product when missing data (NA) are found in matrix Y.
The matrix X must be standardized. See details.
}
\details{
The function ignore missing data when found in matrix Y. Before multiplication of matrices
the missing data in Y are replaced by 0 and multiplication is performed, and then, an adjustment is
performed. This adjustment is done by divide each cell of the product matrix by the sum of
proportions of nonzero at X with complete data in Y. In SYNCSA context this adjustment is done by
divide each cell of the product matrix by the sum of species proportion with trait data in Y.
The matrix X must be standardized, in other words, row totals must be equal to 1.
}
\seealso{
\code{\link{syncsa}}, \code{\link{matmult}},
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{Auxiliary}
