% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_weights.R
\name{plot_weights}
\alias{plot_weights}
\title{Visualize feature loadings (weights)}
\usage{
plot_weights(
  sim_object,
  omic = 1,
  factor_num = 1,
  type = "scatter",
  show.legend = TRUE
)
}
\arguments{
\item{sim_object}{A multi-omics object (e.g., from \code{simulate_twoOmicsData()}
and \code{as_multiomics()}).}

\item{omic}{Integer or character. Which view to plot: \code{1} (omic.one),
\code{2} (omic.two), or \code{"integrated"} (if present). Default \code{1}.}

\item{factor_num}{Integer or "all". Which factor(s) to visualize. Default \code{1}.}

\item{type}{Character. Plot type: \code{"scatter"} or \code{"histogram"}.
Default \code{"scatter"}.}

\item{show.legend}{Logical. Whether to show the legend. Default \code{TRUE}.}
}
\value{
A \link[ggplot2]{ggplot} object (single plot) or a grob returned by
\link[gridExtra]{grid.arrange} when multiple panels are combined.
}
\description{
Generate scatter or histogram plots of feature loadings (weights)
from simulated or real multi-omics data. Supports per-omic views and, when
available, an integrated view.
}
\examples{
output_obj <- simulate_twoOmicsData(
  vector_features = c(4000, 3000),
  n_samples = 100,
  n_factors = 2,
  signal.samples = NULL,
  signal.features.one = NULL,
  signal.features.two = NULL,
  snr = 2.5,
  num.factor = "multiple",
  advanced_dist = "mixed"
)

output_obj <- as_multiomics(output_obj)

plot_weights(
  sim_object = output_obj,
  factor_num = 1,
  omic = 1,
  type = "scatter",
  show.legend = FALSE
)

plot_weights(
  sim_object = output_obj,
  factor_num = 2,
  omic = 2,
  type = "histogram"
)

}
