#' Print method for SDGLM objects
#'
#' @param x An SDGLM object
#' @param ... Additional arguments
#'
#' @export
print.SDGLM <- function(x, ...) {
  cat("Sca-MCMC fit for", x$family, "family\n")
  cat("Method:", x$method, "\n")
  cat("Beta chain dimensions:", dim(x$beta_chain), "\n")
  invisible(x)
}

#' Summary method for SDGLM objects
#'
#' @param object An SDGLM object
#' @param ... Additional arguments
#'
#' @export
summary.SDGLM <- function(object, ...) {
  # Compute posterior means
  beta_mean <- apply(object$beta_chain, 2, mean)
  beta_sd <- apply(object$beta_chain, 2, stats::sd)
  
  result <- data.frame(
    Estimate = beta_mean,
    Std.Error = beta_sd
  )
  
  structure(list(
    coefficients = result,
    family = object$family,
    method = object$method
  ), class = "summary.SDGLM")
}

#' Print method for summary.SDGLM
#'
#' @param x A summary.SDGLM object
#' @param ... Additional arguments
#'
#' @export
print.summary.SDGLM <- function(x, ...) {
  cat("Sca-MCMC summary for", x$family, "family\n")
  cat("Method:", x$method, "\n\n")
  cat("Coefficients:\n")
  print(x$coefficients)
  invisible(x)
}
