% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{SAGMMFit}
\alias{SAGMMFit}
\title{Clustering via Stochastic Approximation and Gaussian Mixture Models (GMM)}
\usage{
SAGMMFit(X, Y = NULL, Burnin = 5, ngroups = 5, kstart = 10, plot = FALSE)
}
\arguments{
\item{X}{numeric matrix of the data.}

\item{Y}{Group membership (if known). Where groups are integers in 1:ngroups. If provided ngroups can}

\item{Burnin}{Ratio of observations to use as a burn in before algorithm begins.}

\item{ngroups}{Number of mixture components. If Y is provided, and groups is not then is overridden by Y.}

\item{kstart}{number of kmeans starts to initialise.}

\item{plot}{If TRUE generates a plot of the clustering.}
}
\value{
A list containing
\item{Cluster}{The clustering of each observation.}
\item{plot}{A plot of the clustering (if requested).}
\item{l2}{Estimate of Lambda^2}
\item{ARI1}{Adjusted Rand Index 1 - using k-means}
\item{ARI2}{Adjusted Rand Index 2 - using GMM Clusters}
\item{ARI3}{Adjusted Rand Index 3 - using intialiation k-means}
\item{KM}{Initial K-means clustering of the data.}
\item{pi}{The cluster proportions (vector of length ngroups)}
\item{tau}{tau matrix of conditional probabilities.}
\item{fit}{Full output details from inner C++ loop.}
}
\description{
Fit a GMM via Stochastic Approximation. See Reference.
}
\examples{
sims<-generateSimData(ngroups=10, Dimensions=10, Number=10^4)
res1<-SAGMMFit(sims$X, sims$Y)
res2<-SAGMMFit(sims$X, ngroups=5)
}
\references{
Nguyen & Jones (2018). Big Data-Appropriate Clustering via Stochastic Approximation and Gaussian Mixture Models. In Data Analytics (pp. 79-96). CRC Press.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
