% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg_net.R
\name{plot_pathway_net}
\alias{plot_pathway_net}
\title{Plot a KEGG pathway network}
\usage{
plot_pathway_net(path_net_c, simplify = FALSE, plot_depth = FALSE, ...)
}
\arguments{
\item{path_net_c}{A `metanet` object representing the pathway network.}

\item{simplify}{Logical, whether to simplify the network by removing multiple edges and loops. Default is `FALSE`.}

\item{plot_depth}{Logical, whether to plot the network as a tree layout. Default is `FALSE`.}

\item{...}{Additional arguments passed to `MetaNet::c_net_plot`.}
}
\value{
A plot of the pathway network.
}
\description{
Plot a KEGG pathway network
}
\examples{
\donttest{
if (requireNamespace("MetaNet") && requireNamespace("ggkegg")) {
  tmp_dir <- tempdir()
  pcutils::download2("https://rest.kegg.jp/get/ko01521/kgml", file.path(tmp_dir, "ko01521.xml"))
  path_net_c <- c_net_from_pathway_xml(file.path(tmp_dir, "ko01521.xml"))
  plot_pathway_net(path_net_c)
  pathway_net_index(path_net_c)
}
}
}
