% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{extract_matches}
\alias{extract_matches}
\title{Extract Matches with Scoring and Limit}
\usage{
extract_matches(
  query,
  choices,
  score_cutoff = 50,
  limit = 3L,
  processor = TRUE,
  scorer = "WRatio"
)
}
\arguments{
\item{query}{The query string to compare.}

\item{choices}{A vector of strings to compare against the query.}

\item{score_cutoff}{A numeric value specifying the minimum similarity score (default is 50.0).}

\item{limit}{The maximum number of matches to return (default is 3).}

\item{processor}{A boolean indicating whether to preprocess strings before comparison (default is TRUE).}

\item{scorer}{A string specifying the similarity scoring method ("WRatio", "Ratio", "PartialRatio", etc.).}
}
\value{
A data frame containing the top matched strings and their similarity scores.
}
\description{
Compares a query string to a list of choices using the specified scorer and returns
the top matches with a similarity score above the cutoff.
}
