% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{damerau_levenshtein_normalized_similarity}
\alias{damerau_levenshtein_normalized_similarity}
\title{Normalized Damerau-Levenshtein Similarity}
\usage{
damerau_levenshtein_normalized_similarity(s1, s2, score_cutoff = 0)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional minimum threshold for the normalized similarity. Defaults to 0.0.}
}
\value{
The normalized Damerau-Levenshtein similarity as a double.
}
\description{
Calculate the normalized Damerau-Levenshtein similarity between two strings.

Computes the normalized similarity based on the Damerau-Levenshtein metric, where the result is between
0.0 (completely different) and 1.0 (identical).
}
\examples{
damerau_levenshtein_normalized_similarity("abcdef", "abcfde")
damerau_levenshtein_normalized_similarity("abcdef", "abcfde", score_cutoff = 0.7)
}
