% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPIV_test.R
\name{RPIV_test}
\alias{RPIV_test}
\title{Residual Prediction Test for Linear Instrumental Variable Models}
\usage{
RPIV_test(
  Y,
  X,
  C = NULL,
  Z,
  frac_A = NULL,
  gamma = 0.05,
  variance_estimator = "heteroskedastic",
  clustering = NULL,
  upper_clip_quantile = 0.8,
  regr_par = list(),
  fit_intercept = TRUE
)
}
\arguments{
\item{Y}{A numeric vector. The outcome variable.}

\item{X}{A numeric matrix or vector. The endogenous explanatory variables.}

\item{C}{A numeric matrix, vector or \code{NULL}. The additional exogenous explanatory variables (optional).}

\item{Z}{A numeric matrix or vector. The instruments.}

\item{frac_A}{A numeric scalar between 0 and 1 or \code{NULL}. The fraction of the sample used for training (sample splitting). Default is \code{min(0.5, exp(1)/log(n))}, where \code{n} is the sample size.}

\item{gamma}{A non-negative scalar. If the variance estimator is less than gamma times the noise level (as estimated as by the mean of the squared residuals), gamma times the noise level is used as variance estimator.}

\item{variance_estimator}{Character string or vector. One or more of \code{"homoskedastic"}, \code{"heteroskedastic"}, \code{"cluster"}. Specifies the types of variance estimation used.}

\item{clustering}{A vector of cluster identifiers or \code{NULL}. Observations with the same value of \code{clustering} belong to the same cluster. Required if \code{variance_estimator} includes \code{"cluster"}.}

\item{upper_clip_quantile}{A scalar between 0 and 1. The estimated weight-function will be clipped at the corresponding quantile of the random forest predictions on the auxiliary sample. Use 0 to use the sign of the predictions. Default is 0.8.}

\item{regr_par}{A list of parameters passed to the random forest regression model. Supports \code{num.trees}, \code{num_mtry} (number of different mtry values to try out) or a vector \code{mtry}, a vector \code{max.depth}, \code{num_min.node.size} (number of different min.node.size values to try out) or a vector \code{min.node.size}.}

\item{fit_intercept}{Logical. Should an intercept be included in the model? Default is \code{TRUE}.}
}
\value{
If a single variance estimator is used, returns a list with:
\describe{
\item{p_value}{p-value of the residual prediction test.}
\item{test_statistic}{The value of the test statistic.}
\item{var_fraction}{The estimated variance fraction, i.e., variance estimator divided by noise level estmate.}
\item{T_null}{The value of the initial test statistic. If var_fraction >= gamma, it is equal to test_statistic, otherwise, it has larger absolute value.}
\item{variance_estimator}{The variance estimator used.}
}
If multiple estimators are supplied, returns a named list of such results for each estimator.
}
\description{
Performs a hypothesis test for the well-specification of linear instrumental variable (IV) model.
More specifically, it tests the null-hypothesis
\eqn{H_0: \exists\beta\in \mathbb R^p \text{ s.t. } \mathbb E[Y-X^T\beta|Z] = 0.}
It uses sample splitting and a random forest to try to predict the two-stage
least-squares residuals from the instruments \eqn{Z}.
}
\details{
The RPIV test splits the sample into an auxiliary and a main sample.
On the auxiliary sample, a random forest is used to predict the two-stage least squares residuals from the instruments.
The test statistic is the scalar product of the two-stage least-squares residuals with a clipped
and rescaled version of the learned function evaluated on the main sample divided by an estimator of its standard deviation.

If \code{clustering} is supplied, sample splitting is done at cluster level (also for \code{variance_estimator} \code{"homoskedastic"} or \code{"heteroskedastic"}).
}
\examples{
set.seed(1)
n <- 100
Z <- rnorm(n)
H <- rnorm(n)
C <- rnorm(n)
X <- Z + rnorm(n) + H
Y1 <- X - C - H + rnorm(n)
Y2 <- X - C - H + rnorm(n) + Z^2
RPIV_test(Y1, X, C, Z)
RPIV_test(Y2, X, C, Z)



}
\references{
Cyrill Scheidegger, Malte Londschien and Peter Bühlmann. A residual prediction test for the well-specification of linear instrumental variable models. Preprint, \url{doi:10.48550/arXiv.2506.12771}, 2025.
}
