% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_measures.R
\name{pp_measures}
\alias{pp_measures}
\title{Measures of interest of a policy portfolio}
\usage{
pp_measures(D, id = NULL, clean_years = FALSE)
}
\arguments{
\item{D}{Data frame in a tidy format with the following columns: "Country", "Sector", "Year", "Instrument", "Target" and "covered". "covered" is a binary identificator of whether the portfolio space is covered by policy intervention (1) or not (0). The remaining columns identify the case. Notice that "Year" is a numeric value, while the remaining 4 case identifiers are factors.}

\item{id}{A list with up to two elements, namely "Country", and "Year" indicating the specific identification characteristics of the portfolio(s) that must be processed. Defaults to NULL to process all portfolios.}

\item{clean_years}{A logical value indicating whether we want to remove observations from countries for which not all years are present. Defaults to FALSE.}
}
\value{
A tidy dataset containing the portfolio identificators (Country, Sector and Year) plus the Measure identificators (Measure and Measure.label) and the value of the portfolio characteristic.
}
\description{
Calculate measures of interest of a policy portfolio.
}
\examples{
data(P.education)
m.education <- pp_measures(P.education)
m.education

# Calculate portfolio measures for a restricted set of portfolios defined by a list.
data(P.energy)
m.energy <- pp_measures(P.energy, id = list(Country = "Borduria", Year = 2022))
m.energy
}
\references{
Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first. For Average Instrument Diversity.

Adam, C., Knill, C. & Fernández-i-Marín, X. (2016). Rule growth and government effectiveness: why it takes the capacity to learn and coordinate to constrain rule growth. _Policy Sciences_, 50, 241–268. doi:10.1007/s11077-016-9265-x. For portfolio size.
}
\seealso{
\code{\link{diversity_aid}} for Average Instrument Diversity, \code{\link[ineq]{Gini}}, \code{\link[vegan]{diversity}} \code{\link{configurations}}.
}
