\name{fit_PTL}
\alias{fit_PTL}
\title{PTL (Partial Transfer Learning) Fit}
\description{
  Fits partial transfer learning with cross-fitting and outcome reconstruction.
  Uses double machine learning on the source and SCAD on the outcome nuisance,
  then transfers to the target via the partial transfer formula.
}
\usage{
fit_PTL(D_t, X_t, Y_t, D_s, X_s, Y_s, ml_f, ml_g, fold = 5L)
}
\arguments{
  \item{D_t}{Target treatment; \eqn{n_t \times 1} matrix.}
  \item{X_t}{Target design matrix; \eqn{n_t \times p}.}
  \item{Y_t}{Target outcome; \eqn{n_t \times 1}.}
  \item{D_s}{Source treatment; \eqn{n_s \times 1}.}
  \item{X_s}{Source design matrix; \eqn{n_s \times p}.}
  \item{Y_s}{Source outcome; \eqn{n_s \times 1}.}
  \item{ml_f}{Outcome learner for DoubleML (e.g. \code{lrn("regr.cv_glmnet")}).}
  \item{ml_g}{Treatment learner for DoubleML (same type).}
  \item{fold}{Number of folds for cross-fitting (default 5).}
}
\value{
  A list with components:
  \item{hat_rho_s}{Source causal estimate.}
  \item{beta_hat_s}{Source nuisance coefficient estimate.}
  \item{E_s}{Estimated \eqn{E[Y - \rho D]} on source (NA when \code{q != 1}).}
  \item{hat_rho_PTL}{PTL causal estimate on target.}
}
\seealso{
  \code{\link{fit_HPTL}}, \code{\link{DGP}}, \code{\link{RMSE}}
}
