\name{boot_detection}
\alias{boot_detection}
\title{Bootstrap-Based Source Detection}
\description{
  Identifies which sources are transferable to the target by comparing
  bootstrap estimates of the nuisance function on the target and each
  source. A source is detected as transferable if the difference is below
  a threshold proportional to the combined standard error.
}
\usage{
boot_detection(D_t, X_t, Y_t, D_s_all, X_s_all, Y_s_all, source_sizes, B,
               ml_f, ml_g)
}
\arguments{
  \item{D_t}{Target treatment; \eqn{n_t \times 1}.}
  \item{X_t}{Target design matrix; \eqn{n_t \times p}.}
  \item{Y_t}{Target outcome; \eqn{n_t \times 1}.}
  \item{D_s_all}{Source treatments concatenated by row; rows split by \code{source_sizes}.}
  \item{X_s_all}{Source design matrices concatenated by row.}
  \item{Y_s_all}{Source outcomes concatenated by row.}
  \item{source_sizes}{Integer vector of length K: sample size of each source.}
  \item{B}{Number of bootstrap replications.}
  \item{ml_f}{Outcome learner for DoubleML.}
  \item{ml_g}{Treatment learner for DoubleML.}
}
\value{
  A data frame with columns \code{Source} (label) and \code{detected.source}
  (list of logical vectors of length B per source).
}
\seealso{
  \code{\link{run_bootstrap_E_hat}}, \code{\link{fit_PTL}}, \code{\link{fit_HPTL}}
}
