% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.urine.R
\name{pk.calc.ae}
\alias{pk.calc.ae}
\title{Calculate amount excreted (typically in urine or feces)}
\usage{
pk.calc.ae(conc, volume, check = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{volume}{The volume (or mass) of the sample}

\item{check}{Should the concentration and volume data be checked?}
}
\value{
The amount excreted during the interval
}
\description{
Calculate amount excreted (typically in urine or feces)
}
\details{
ae is \code{sum(conc*volume)}.

The units for the concentration and volume should match such that
\code{sum(conc*volume)} has units of mass or moles.
}
\seealso{
\code{\link[=pk.calc.clr]{pk.calc.clr()}}, \code{\link[=pk.calc.fe]{pk.calc.fe()}}
}
