% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_tp_param_surv_extrap}
\alias{f_plot_tp_param_surv_extrap}
\title{Plot Extrapolated Annual Transition Probabilities (Parametric Models)}
\usage{
f_plot_tp_param_surv_extrap(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object returned by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
Invisibly returns \code{NULL}. The function draws one or more base R plots as side effects.
}
\description{
Plot smoothed observed annual transition probabilities with shaded confidence
intervals and overlay predictions from all fitted parametric survival models.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_tp_param_surv_extrap(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
