% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/management_defaults.R
\name{add_management}
\alias{add_management}
\title{Estimate default values for management}
\usage{
add_management(
  ID,
  B_LU_BRP,
  B_SOILTYPE_AGR,
  M_GREEN = NA,
  M_NONBARE = NA,
  M_EARLYCROP = NA,
  M_COMPOST = NA_real_,
  M_SLEEPHOSE = NA,
  M_DRAIN = NA,
  M_DITCH = NA,
  M_UNDERSEED = NA,
  M_LIME = NA,
  M_NONINVTILL = NA,
  M_SSPM = NA,
  M_SOLIDMANURE = NA,
  M_STRAWRESIDUE = NA,
  M_MECHWEEDS = NA,
  M_PESTICIDES_DST = NA
)
}
\arguments{
\item{ID}{(character) A field id}

\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{M_GREEN}{(boolean) A soil measure. Are catch crops sown after main crop (optional, option: yes or no)}

\item{M_NONBARE}{(boolean) A soil measure. Is parcel for 80 percent of the year cultivated and 'green' (optional, option: yes or no)}

\item{M_EARLYCROP}{(boolean) A soil measure. Use of early crop varieties to avoid late harvesting (optional, option: yes or no)}

\item{M_COMPOST}{(numeric) The frequency that compost is applied (optional, every x years)}

\item{M_SLEEPHOSE}{(boolean) A soil measure. Is sleephose used for slurry application (optional, option: yes or no)}

\item{M_DRAIN}{(boolean) A soil measure. Are under water drains installed in peaty soils (optional, option: yes or no)}

\item{M_DITCH}{(boolean) A soil measure. Are ditched maintained carefully and slib applied on the land (optional, option: yes or no)}

\item{M_UNDERSEED}{(boolean) A soil measure. Is grass used as second crop in between maize rows (optional, option: yes or no)}

\item{M_LIME}{(boolean) measure. Has field been limed in last three years (option: yes or no)}

\item{M_NONINVTILL}{(boolean) measure. Non inversion tillage (option: yes or no)}

\item{M_SSPM}{(boolean) measure. Soil Structure Protection Measures, such as fixed driving lines, low pressure tires, and light weighted machinery (option: yes or no)}

\item{M_SOLIDMANURE}{(boolean) measure. Use of solid manure (option: yes or no)}

\item{M_STRAWRESIDUE}{(boolean) measure. Application of straw residues (option: yes or no)}

\item{M_MECHWEEDS}{(boolean) measure. Use of mechanical weed protection (option: yes or no)}

\item{M_PESTICIDES_DST}{(boolean) measure. Use of DST for pesticides (option: yes or no)}
}
\value{
A data.table with all default estimates for the management measures that are used for the Label Sustainable Soil Management.
For each B_LU_BRP 15 management measures are given, all as boolean variables except for M_COMPOST being a numeric value.
}
\description{
This function adds default management input variables given soil type and land use
}
\details{
Potato and maize cultivations on sandy soil will always have M_GREEN = TRUE,
in line with Dutch legislation.
}
\examples{
add_management(ID = 1, B_LU_BRP = 256, B_SOILTYPE_AGR = 'dekzand')
add_management(ID = 1, B_LU_BRP = c(256,1019), B_SOILTYPE_AGR = rep('dekzand',2))

}
