'#
  Authors
Torsten Pook, torsten.pook@wur.nl

Copyright (C) 2017 -- 2025  Torsten Pook

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'#

#' Haldane recombination function
#'
#' Standard haldane function
#' @param noc number of recombination points
#' @param length.genome Length of the genome
#' @examples
#' recombination.function.haldane(5, 10)
#' @return Vector of recombination events
#' @export

recombination.function.haldane = function(noc, length.genome){
  rec = stats::runif(noc,0,length.genome)
  return(rec)
}
