% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_refseq_extremity_pq}
\alias{plot_refseq_extremity_pq}
\title{Plot the nucleotide proportion at both extremity of the sequences}
\usage{
plot_refseq_extremity_pq(
  physeq,
  first_n = 10,
  last_n = 10,
  hill_scales = c(1, 2),
  min_width = 0
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{first_n}{(int, default 10) The number of nucleotides to plot the 5' extremity.}

\item{last_n}{(int, default 10) The number of nucleotides to plot the 3' extremity.}

\item{hill_scales}{(vector) A vector defining the Hill number wanted. Set to NULL if
you don't want to plot Hill diversity metrics.}

\item{min_width}{(int, default 0) Select only the sequences from physeq@refseq with using a
minimum length threshold. If \code{first_n} is superior to the minimum length of the
references sequences, you must use min_width to filter out the narrower sequences}
}
\value{
A list of 4 objects
\itemize{
\item p_start and p_last are the ggplot object representing respectively the start and
the end of the sequences.
\item df_start and df_last are the data.frame corresponding to the ggplot object.
}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


It is a useful function to check for the absence of unwanted patterns caused
for example by Illumina adaptator or bad removal of primers.

If \code{hill_scale} is not null, Hill diversity number are used to represent the distribution
of the diversity (equitability) along the sequences.
}
\examples{
res1 <- plot_refseq_extremity_pq(data_fungi)
names(res1)
res1$plot_start
res1$plot_last

res2 <- plot_refseq_extremity_pq(data_fungi, first_n = 200, last_n = 100)
res2$plot_start
res2$plot_last

plot_refseq_extremity_pq(data_fungi,
  first_n = 400,
  min_width = 400,
  hill_scales = NULL
)$plot_start +
  geom_line(aes(y = value, x = seq_id, color = name), alpha = 0.4, linewidth = 0.2)

plot_refseq_extremity_pq(data_fungi,
  first_n = NULL,
  last_n = 400,
  min_width = 400,
  hill_scales = c(3)
)$plot_last
}
\author{
Adrien Taudière
}
