% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mvn.R
\name{summary.mvn}
\alias{summary.mvn}
\title{Summarize Multivariate Normality Analysis Results}
\usage{
\method{summary}{mvn}(
  object,
  select = c("mvn", "univariate", "descriptives", "outliers", "new_data"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{mvn}, as returned by the \code{\link{mvn}} function.}

\item{select}{A character vector specifying which components to display. 
Must be one or more of \code{"mvn"}, \code{"univariate"}, \code{"descriptives"}, \code{"outliers"}, or \code{"new_data"}.
Defaults to showing all available sections.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the input object.
}
\description{
Provides a structured summary of the results from an object of class \code{mvn},
including multivariate and univariate normality tests, descriptive statistics,
and multivariate outlier detection (if applicable).
}
\examples{
\dontrun{
data <- iris[1:4]
result <- mvn(data)

summary(result)  # Show all sections
summary(result, select = c("mvn", "outliers"))  # Show selected sections only
}

}
