% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addggLayers.r
\name{addggLayers}
\alias{addggLayers}
\title{addggLayers}
\usage{
addggLayers(
  g,
  data,
  type = c("ebp", "spike"),
  ylim = layer_scales(g)$y$get_limits(),
  by = "variable",
  value = "value",
  frac = 0.065,
  mult = 1,
  facet = NULL,
  pos = c("bottom", "top"),
  showN = TRUE
)
}
\arguments{
\item{g}{a \code{ggplot} object}

\item{data}{data frame/table containing raw data}

\item{type}{specifies either extended box plot or spike histogram.  Both are horizontal so are showing the distribution of the x-axis variable.}

\item{ylim}{y-axis limits to use for scaling the height of the added plots, if you don't want to use the limits that \code{ggplot} has stored}

\item{by}{the name of a variable in \code{data} used to stratify raw data}

\item{value}{name of x-variable}

\item{frac}{fraction of y-axis range to devote to vertical aspect of the added plot}

\item{mult}{fudge factor for scaling y aspect}

\item{facet}{optional faceting variable}

\item{pos}{position for added plot}

\item{showN}{sete to \code{FALSE} to not show sample sizes}
}
\value{
the original \code{ggplot} object with more layers added
}
\description{
Add Spike Histograms and Extended Box Plots to \code{ggplot}
}
\details{
For an example see \href{https://hbiostat.org/rflow/analysis.html#fig-table1}{this}.  Note that it was not possible to just create the layers needed to be added, as creating these particular layers in isolation resulted in a \code{ggplot} error.
}
\seealso{
\code{spikecomp()}
}
\author{
Frank Harrell
}
