% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_simulation.R
\name{simulate_finite_FDOTT}
\alias{simulate_finite_FDOTT}
\alias{simulate_limit_FDOTT_null}
\alias{simulate_limit_FDOTT_alt}
\title{Simulations for \code{FDOTT}}
\usage{
simulate_finite_FDOTT(mu, costm, n, H0 = "*", num.sim = 1000)

simulate_limit_FDOTT_null(
  mu,
  costm,
  n = NULL,
  delta = NULL,
  H0 = "*",
  num.sim = 1000,
  method = c("plug-in", "bootstrap-deriv", "bootstrap-m"),
  m.p = 0.5,
  mean = NULL
)

simulate_limit_FDOTT_alt(mu, costm, delta, H0 = "*", num.sim = 1000)
}
\arguments{
\item{mu}{matrix (row-wise) or nested list containing \eqn{K} probability vectors.}

\item{costm}{semi-metric cost matrix \eqn{c \in \mathbb{R}^{N \times N}}.}

\item{n}{samples sizes. Must be of the same structure as \code{mu}.}

\item{H0}{null hypothesis, see \code{\link{FDOTT}} for more information.}

\item{num.sim}{number of samples to draw from the limiting null distribution.}

\item{delta}{asymptotic sample size ratios. Must be of the same structure as \code{mu}.}

\item{method}{the method to use to simulate from the null distribution.}

\item{m.p}{exponent \eqn{p \in (0, 1)} used for \code{method = "bootstrap-m"}.}

\item{mean}{mean of the Gaussians appearing in the limiting distribution. Must be of the same structure as \code{mu}.}
}
\value{
A vector containing the simulated samples.
}
\description{
Perform simulations for the test statistic used in \code{\link{FDOTT}}.
}
\details{
See \code{\link{FDOTT}} for the definition of the test statistic and more details.

\code{simulate_finite_FDOTT} simulates from the finite sample distribution.

\code{simulate_limit_FDOTT_null} and \code{simulate_limit_FDOTT_alt} simulate from the limiting distribution under the null or alternative, respectively.

All these simulations can be done in parallel via \code{\link[future:plan]{future::plan}} and the progress can be shown with \code{\link[progressr:with_progress]{progressr::with_progress}}.
}
\examples{


# enable txt progressbar
progressr::handlers("txtprogressbar")
# enable parallel computation
if (requireNamespace("future")) {
    future::plan(future::multisession)
}

K <- 3
N <- 2
costm <- cost_matrix_lp(1:N)

# use higher values for better approximation
num.sim <- 10
n <- rep(300, K)

delta <- rep(1 / K, K)

# under one-way null
mu <- matrix(1 / N, K, N, TRUE)

set.seed(123)
lhs <- simulate_finite_FDOTT(mu, costm, n, num.sim = num.sim)
rhs <- simulate_limit_FDOTT_null(mu, costm, delta = delta, num.sim = num.sim)

h1 <- density(lhs)
h2 <- density(rhs)
plot(h1$x, h1$y, xlim = range(h1$x, h2$x), ylim = range(h1$y, h2$y), type = "l",
     col = "red", xlab = "x", ylab = "density", main = "KDEs")
lines(h2$x, h2$y, col = "blue")
legend("topright", c("Finite", "Limit"), col = c("red", "blue"), pch = 15)

# under one-way alternative
mu[2, ] <- 1:N / sum(1:N)

set.seed(123)
lhs <- simulate_finite_FDOTT(mu, costm, n, num.sim = num.sim)
rhs <- simulate_limit_FDOTT_alt(mu, costm, delta, num.sim = num.sim)

h1 <- density(lhs)
h2 <- density(rhs)
plot(h1$x, h1$y, xlim = range(h1$x, h2$x), ylim = range(h1$y, h2$y), type = "l",
     col = "red", xlab = "x", ylab = "density", main = "KDEs")
lines(h2$x, h2$y, col = "blue")
legend("topright", c("Finite", "Limit"), col = c("red", "blue"), pch = 15)
\dontshow{
## R CMD check: make sure any open connections are closed afterward
if (requireNamespace("future") && !inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
