% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_quad.R
\encoding{UTF-8}
\name{gauss_quad}
\alias{gauss_quad}
\title{Numerical integration through Gaussian Quadrature}
\usage{
gauss_quad(
  fun,
  lower,
  upper,
  kind = "legendre",
  n = 10,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{fun}{an \strong{R} function which should take a numeric argument x and
possibly some parameters. The function returns a numerical vector
value for the given argument \code{x}.}

\item{lower}{a numeric value for the lower limit of the integral.}

\item{upper}{a numeric value for the upper limit of the integral.}

\item{kind}{character specifying the weight (polynomial) function for the
quadrature.}

\item{n}{integer with the highest order of the polynomial of the selected
rule.}

\item{normalized}{logical. If TRUE, rules are for orthonormal polynomials,
otherwise they are for orthogonal polynomials.}

\item{...}{additional arguments to be passed to \code{fun} and to the
quadrature routine specified in argument \code{kind}.}
}
\value{
The value of the integral of the function specified in \code{fun}
argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This family of functions use quadratures for solving integrals. The user can
create a custom integration routine, see \emph{details} for further
information.
}
\details{
\code{gauss_quad} uses the implementation of Gaussian quadratures from
\strong{gaussquad} package.This is a wrapper that implements \code{rules}
and integration routine in the same place.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: Mean of X ~ N(2,1) (Gauss-Hermitie quadrature).
g <- function(x, mu, sigma) sqrt(2)*sigma*x + mu
i2 <- gauss_quad(g, lower = -Inf, upper = Inf, kind = 'hermite.h',
                 normalized = FALSE, mu = 2, sigma = 1)
i2 <- i2/sqrt(pi)
i2


#----------------------------------------------------------------------------

}
\seealso{
\code{\link[gaussquad]{laguerre.quadrature}},
\code{\link[gaussquad]{legendre.quadrature}},
\code{\link[gaussquad]{chebyshev.c.quadrature}},
\code{\link[gaussquad]{gegenbauer.quadrature}},
\code{\link[gaussquad]{hermite.h.quadrature}}, etc.
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{Integration functions}
