% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveInoculumStatesBP.R
\name{solveInoculumStatesBP}
\alias{solveInoculumStatesBP}
\title{Compute Epidemic Probability via Transition and Fertility Matrices}
\usage{
solveInoculumStatesBP(numVars, ext_pams, est_pams, interv)
}
\arguments{
\item{numVars}{Numeric. Number of inoculum states (determined by the number of insects per plant in the main function).}

\item{ext_pams}{Numeric vector of length 5. Local rate parameters (per day):
The first element specifies the Vector dispersal rate,
the second the Roguing rate,
the third the Vector mortality rate,
the forth the Harvesting rate,
the fifth the Plant latent progression rate}

\item{est_pams}{Numeric vector of length 3. Virus rate parameters (per day):
\describe{
\item{\code{[1]}}{Acquisition rate.}
\item{\code{[2]}}{Inoculation rate.}
\item{\code{[3]}}{Insect recovery rate.}
}}

\item{interv}{Numeric. Value of the transition matrix time step.}
}
\value{
Numeric array. A combined array (\code{rbind}) of:
\describe{
\item{ttilde}{Extended transition probability matrix.}
\item{f}{Fertility matrix.}
}
The returned array has dimensions (numVars + 1 + numVars) x numVars. The additional row in ttilde represents
the probability of no event occurring within a time step.
}
\description{
Computes the extended transition probability matrix and fertility matrix used in epidemic probability calculations.
}
\details{
Computes the transition probability matrix used in extinction probability calculations.
The function returns two matrices:
\itemize{
\item ttilde: Population transition matrix.
\item f: Fertility matrix.
The matrix dimensions depend on the number of insects per plant, allowing for flexibility across different insect burdens.
For further details, refer to Donnelly, Tankam, and Gilligan (2025, manuscript).
}
}
\keyword{internal}
