% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support.R
\name{fisher.pvalues.support}
\alias{fisher.pvalues.support}
\title{Computing Discrete P-Values and Their Supports for Fisher's Exact Test}
\usage{
fisher.pvalues.support(counts, alternative = "greater", input = "noassoc")
}
\arguments{
\item{counts}{a data frame of two or four columns and any number of
lines; each line represents a 2x2 contingency table to
test. The number of columns and what they must contain
depend on the value of the \code{input} argument, see
Details.}

\item{alternative}{same argument as in \code{\link[stats:fisher.test]{stats::fisher.test()}}. The three
possible values are \code{"greater"} (default),
\code{"two.sided"} or \code{"less"} and you can specify
just the initial letter.}

\item{input}{the format of the input data frame, see Details. The
three possible values are \code{"noassoc"} (default),
\code{"marginal"} or \code{"HG2011"} and you can specify
just the initial letter.}
}
\value{
A list of two elements:
\item{raw}{raw discrete p-values.}
\item{support}{a list of the supports of the CDFs of the p-values.
Each support is represented by a vector in increasing order.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Computes discrete raw p-values and their support for Fisher's exact test
applied to 2x2 contingency tables summarizing counts coming from two
categorical measurements.

\strong{Note}: This function is deprecated and will be removed in a future
version. Please use \code{\link[=generate.pvalues]{generate.pvalues()}} with
\code{test.fun = DiscreteTests::fisher.test.pv} and (optional)
\code{preprocess.fun = DiscreteDatasets::reconstruct_two} or
\code{preprocess.fun = DiscreteDatasets::reconstruct_four} instead. Alternatively,
use a pipeline like\cr
\verb{data |>}\cr
\verb{  DiscreteDatasets::reconstruct_*(<args>) |>}\cr
\verb{  DiscreteTests::fisher.test.pv(<args>)}
}
\details{
Assume that each contingency tables compares two variables and resumes the
counts of association or not with a condition. This can be resumed in the
following table:
\tabular{lccc}{
\tab   Association   \tab No association  \tab   Total   \cr
Variable 1  \tab    \eqn{X_1}    \tab    \eqn{Y_1}    \tab \eqn{N_1} \cr
Variable 2  \tab    \eqn{X_2}    \tab    \eqn{Y_2}    \tab \eqn{N_2} \cr
Total       \tab \eqn{X_1 + X_2} \tab \eqn{Y_1 + Y_2} \tab \eqn{N_1 + N_2}
}
If \code{input="noassoc"}, \code{counts} has four columns which respectively contain,
\eqn{X_1}, \eqn{Y_1}, \eqn{X_2} and \eqn{Y_2}. If \code{input="marginal"},
\code{counts} has four columns which respectively contain \eqn{X_1}, \eqn{N_1},
\eqn{X_2} and \eqn{N_2}.

If \code{input="HG2011"}, we are in the situation of the \code{amnesia} data set as
in Heller & Gur (2011, see References). Each contingency table is obtained
from one variable which is compared to all other variables of the study. That
is, counts for "second variable" are replaced by the sum of the counts of the
other variables:
\tabular{lccc}{
\tab Association \tab No association \tab Total \cr
Variable  \eqn{j}      \tab \eqn{X_j}   \tab \eqn{Y_j} \tab  \eqn{N_j} \cr
Variables \eqn{\neq j} \tab \eqn{\sum_{i \neq j} X_i}
\tab \eqn{\sum_{i \neq j} Y_i} \tab \eqn{\sum_{i \neq j} N_i} \cr
Total \tab \eqn{\sum X_i} \tab \eqn{\sum Y_i} \tab \eqn{\sum N_i}
}
Hence \code{counts} needs to have only two columns which respectively contain
\eqn{X_j} and \eqn{Y_j}.

The code for the computation of the p-values of Fisher's exact test is
inspired by the example in the help page of \code{p.discrete.adjust} of package
\code{discreteMTP}, which is no longer available on CRAN.

See the Wikipedia article about Fisher's exact test, paragraph Example, for
a good depiction of what the code does for each possible value of
\code{alternative}.
}
\examples{
X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

# Compute p-values and their supports of Fisher's exact test
df.formatted <- fisher.pvalues.support(counts = df, input = "noassoc")
raw.pvalues <- df.formatted$raw
pCDFlist <- df.formatted$support
}
\references{
R. Heller and H. Gur (2011). False discovery rate controlling procedures for
discrete tests. arXiv preprint.
\href{https://arxiv.org/abs/1112.4627v2}{arXiv:1112.4627v2}.

"Fisher's exact test", Wikipedia, The Free Encyclopedia, accessed 2024-12-14,
\href{https://en.wikipedia.org/wiki/Fisher\%27s_exact_test}{link}.
}
\seealso{
\code{\link[=fisher.test]{fisher.test()}}
}
