% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_deep.R
\name{pattc_deeplearning}
\alias{pattc_deeplearning}
\title{Deep PATT-C}
\usage{
pattc_deeplearning(
  response.formula,
  compl.var,
  treat.var,
  exp.data,
  pop.data,
  compl.algorithm = "adam",
  response.algorithm = "adam",
  compl.hidden.layer = c(4, 2),
  response.hidden.layer = c(4, 2),
  compl.hidden_activation = "relu",
  response.hidden_activation = "relu",
  response.output_activation = "linear",
  response.output_units = 1,
  response.loss = "mean_squared_error",
  response.metrics = "mean_absolute_error",
  ID = NULL,
  weights = NULL,
  cluster = NULL,
  compl.epoch = 10,
  response.epoch = 10,
  compl.validation_split = NULL,
  response.validation_split = NULL,
  compl.patience = NULL,
  response.patience = NULL,
  compl.dropout_rate = NULL,
  response.dropout_rate = NULL,
  verbose = 1,
  batch_size = 32,
  nboot = 1000,
  seed = 1234
)
}
\arguments{
\item{response.formula}{formula specifying the response variable and covariates.}

\item{compl.var}{string specifying the name of the compliance variable.}

\item{treat.var}{string specifying the name of the treatment variable.}

\item{exp.data}{data frame containing the experimental data.}

\item{pop.data}{data frame containing the population data.}

\item{compl.algorithm}{string for name of optimizer algorithm for complier model. For optimizers available see \code{keras} package.}

\item{response.algorithm}{string for name of optimizer algorithm for response model. For optimizers available see \code{keras} package.}

\item{compl.hidden.layer}{vector specifying the hidden layers in the complier model and the number of neurons in each hidden layer.}

\item{response.hidden.layer}{vector specifying the hidden layers in the response model and the number of neurons in each hidden layer.}

\item{compl.hidden_activation}{string or vector for name of activation function for hidden layers complier model. Defaults to "relu" (Rectified Linear Unit)}

\item{response.hidden_activation}{string or vector for name of activation function for hidden layers complier model. Defaults to "relu" (Rectified Linear Unit)}

\item{response.output_activation}{string for name of activation function for output layer of response model.
"linear" is recommended for continuous outcome variables, and "sigmoid" for binary outcome variables.
For activation functions available see \code{keras} package.}

\item{response.output_units}{integer for units in output layer. Defaults to 1 for continuous and binary outcome variables. In case of multinomial outcome variable, set to the number of categories.}

\item{response.loss}{string for loss function in response model. "mean_squared_error" recommended for linear models,
"binary_crossentropy" for binary models.}

\item{response.metrics}{string for metrics in response model. "mean_squared_error" recommended for linear models,
"binary_accuracy" for binary models.}

\item{ID}{optional string specifying the name of the identifier variable.}

\item{weights}{optional string specifying the name of the weights variable.}

\item{cluster}{optional string specifying the name of the clustering variable.}

\item{compl.epoch}{Integer for the number of epochs for complier model.}

\item{response.epoch}{integer for the number of epochs for response model.}

\item{compl.validation_split}{double for the proportion of test data to be split as validation in complier model. Defaults to 0.2.}

\item{response.validation_split}{double for the proportion of test data to be split as validation in response model. Defaults to 0.2.}

\item{compl.patience}{integer for number of epochs with no improvement after which training will be stopped in complier model.}

\item{response.patience}{integer for number of epochs with no improvement after which training will be stopped in response model.}

\item{compl.dropout_rate}{double or vector for proportion of hidden layer to drop out in complier model.}

\item{response.dropout_rate}{double or vector for proportion of hidden layer to drop out in response model.}

\item{verbose}{integer specifying the verbosity level during training. Defaults to 1.}

\item{batch_size}{integer specifying the batch size for training the deep learning models. Default is 32.}

\item{nboot}{integer specifying the number of bootstrap samples if bootstrap is TRUE. Default is 1000.}

\item{seed}{random seed}
}
\value{
pattc_deeplearning object containing the fitted models, predictions, counterfactuals, and PATT-C estimate.
}
\description{
This function implements the Deep PATT-C method for estimating the Population Average Treatment
Effect on the Treated Compliers (PATT-C) using deep learning models using keras and Tensorflow.
It consists of training a deep learning model to predict compliance among treated individuals,
predicting compliance in the experimental data, training a response model among predicted compliers,
and estimating counterfactual outcomes in the population data.
}
\examples{
\dontrun{
#check for python and required modules
python_ready()

data("exp_data")
data("pop_data")
set.seed(1243)
deeppattc <- pattc_deeplearning(response.formula = support_war ~ age + female +
income + education +  employed + married + hindu + job_loss,
exp.data = exp_data, pop.data = pop_data,
treat.var = "strong_leader",  compl.var = "compliance",
compl.algorithm = "adam", response.algorithm = "adam",
compl.hidden.layer = c(4,2),  response.hidden.layer = c(4,2),
compl.hidden_activation = "relu",  response.hidden_activation = "relu",
response.output_activation = "sigmoid", response.output_units = 1, 
response.loss = "binary_crossentropy", response.metrics = "accuracy",
compl.epoch = 50, response.epoch = 80,
verbose = 1, batch_size = 32, 
compl.validation_split = 0.2, response.validation_split = 0.2,
compl.dropout_rate = 0.1, response.dropout_rate = 0.1,
compl.patience = 20, response.patience = 20,
nboot = 1000, seed = 1234)
}
}
