% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{theme_DI}
\alias{theme_DI}
\title{Default theme for DImodelsVis}
\usage{
theme_DI(
  font_size = 14,
  font_family = "",
  legend = c("top", "bottom", "left", "right", "none")
)
}
\arguments{
\item{font_size}{Base font size for text across the plot}

\item{font_family}{Font family for text across the plot}

\item{legend}{One of c("top", "bottom", "left", "right", "none") specifying
the position of the legend. The legend position can also be
specified as a numeric vector of form c(x, y) with x and y
having values between 0 and 1. If specified as a numeric vector
the legend within the plotting region where c(0,0) corresponds
to the "bottom left" and c(1,1) corresponds to the "top right"
position. The default position is "top".}
}
\value{
A ggplot theme object
}
\description{
Default theme for DImodelsVis
}
\examples{
library(ggplot2)

plot_data <- mtcars
plot_data$gear <- as.factor(plot_data$gear)
ggplot(data = plot_data,
       aes(x = mpg, y = disp, colour = gear))+
   geom_point(size = 3)+
   facet_wrap(~cyl) +
   theme_DI()
}
