# ---------- model selection ----------
#' Select best mixture model (lognormal or normal) based on BIC
#'
#' @param x numeric vector
#' @param n_runs number of DEoptim runs
#' @param NP population size for DEoptim
#' @param itermax maximum iterations
#' @param quiet verbosity
#' @return list with best fit, all fits, and BICs
#' @export
select_best_mixture <- function(x, n_runs = 1, NP = 50, itermax = 10000, quiet = 2) {
  res_list <- list()
  try_lognorm <- all(x > 0)
  if (try_lognorm) {
    res_ln <- try(fit_lognorm2(x, n_runs = n_runs, NP = NP, itermax = itermax, quiet = quiet), silent = TRUE)
    if (!inherits(res_ln, "try-error")) res_list$lognormal <- res_ln
  }
  res_n <- try(fit_norm2(x, n_runs = n_runs, NP = NP, itermax = itermax, quiet = quiet), silent = TRUE)
  if (!inherits(res_n, "try-error")) res_list$normal <- res_n
  if (length(res_list) == 0) stop("Both models failed")
  BICs <- sapply(res_list, function(z) z$BIC)
  best_family <- names(which.min(BICs))
  list(best = res_list[[best_family]], all = res_list, BICs = BICs)
}
